use master
GO

set nocount on 

--set to 0 to skip updating the A4Panel_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @PanelClientPayload01 nvarchar(max) = N'
-- DEV-91818 
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[A4S_sp_ProcessSamplePanelists]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[A4S_sp_ProcessSamplePanelists]
'

declare @PanelClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_ProcessSamplePanelists]
 @clientId    INT,
 @panelId    INT,
 @sampleId    INT,
 @userId     INT,
 @destinationSurveyId INT,
 @doPanelistDataTransfer BIT,
 @autoGeneratePIN  INT,
 @pinSource    nvarchar(max) = '''',
 @updateOnly bit = 0
AS
BEGIN
 DECLARE @schemaName NVARCHAR(50)
 DECLARE @destinationSchemaName NVARCHAR(100)
 DECLARE @panelSchema NVARCHAR(50)
 DECLARE @sql NVARCHAR(max)
 SET @schemaName = ''[A4Survey_Client_''+CONVERT(nvarchar, @clientId)+'']''
 SET @destinationSchemaName = @schemaName+''.[Survey_''+CONVERT(nvarchar, @clientId)+''_''+CONVERT(nvarchar, @destinationSurveyId)+'']''
 SET @panelSchema = ''[A4Panel_Client_''+CONVERT(nvarchar, @clientId)+'']''

 IF @updateOnly = 0
 BEGIN
    DECLARE @attributeId int = 0
    DECLARE @panelistProperty int = 0  

    -- When not auto generate then check if source exists and what is the source
    IF @autoGeneratePIN = 0
    BEGIN  
        SET @attributeId = dbo.GetPanelAttributeId(@panelid, @pinSource)

        -- If not a panelist attribute check if panelists property
        IF @attributeId = 0
        BEGIN
            SET @panelistProperty = dbo.IsPanelistProperty(@pinSource)
        END
    END
    
    -- If no panelist property for PIN generation then make sure we have a valid column name for the SQL query
    IF @panelistProperty = 0
    BEGIN
        SET @pinSource = ''UserName''
    END

  SET @sql = ''
  INSERT INTO ''+@destinationSchemaName+''.[Respondent] 
  ([panelistId], [ResEmail], [ResPhone], [CreatedBy],[CreationDate], [modifiedby],[modified],[ResCompleted], [ResActive], [ResAcquiredLicense], [SampleId], [ResPin], [ResLanguageCode], [ResTimeZone])
  SELECT panelist.[Id], panelist.[Email], panelist.[Phone], @userId, GETUTCDATE(), @userId, 0 ,0, case when panelist.status=6 then 0 else 1 end, 0, @sampleId,
  CASE WHEN  @autoGeneratePIN  = 0 AND @panelistProperty = 1 THEN panelist.['' + @pinSource + '']
    WHEN @autoGeneratePIN  = 0 AND @attributeId > 0 THEN attribute.Value
    ELSE CONVERT(nvarchar, @panelId)+LEFT(NEWID(),5)+CONVERT(nvarchar, panelist.[Id]) 
  END, 
  panelist.[Language], panelist.[TimeZone]
  FROM #PanelistToInsert pti
  INNER JOIN  ''+@panelSchema+''.[dbo].[Panelists] panelist WITH(NOLOCK) ON panelist.[Id] = pti.[Id]
  LEFT OUTER JOIN ''+@panelSchema+''.[dbo].[PanelistAttributes] attribute WITH(NOLOCK) ON attribute.PanelistId = panelist.[Id] AND attribute.AttributeDefinitionId = @attributeId
  WHERE NOT EXISTS (SELECT 1 FROM ''+@destinationSchemaName+''.[Respondent] r WITH(NOLOCK) WHERE r.[panelistId] = pti.Id)''
 
  EXEC sp_executesql @sql, N''@surveyId INT, @sampleId INT, @panelId INT, @userId INT, @autoGeneratePIN INT, @panelistProperty INT, @attributeId int '', @destinationSurveyId, @sampleId, @panelId, @userId,  @autoGeneratePIN, @panelistProperty, @attributeId

  -- Insert created respondents in PanelistRespondents table
  SET @sql = ''
  INSERT INTO ''+@panelSchema+''.[dbo].[PanelistRespondents] ([SurveyId], [PanelistId], [RespondentId], [RespondentActive], [RespondentOnline]) 
  SELECT @surveyId, res.[PanelistId], res.[ResRespondent], res.[ResActive], res.[ResOnline]
  FROM #PanelistToInsert pti
  INNER JOIN ''+@destinationSchemaName+''.[Respondent] res WITH(NOLOCK) ON res.[PanelistId] = pti.[Id]''

  EXEC sp_executesql @sql, N''@surveyId INT'', @destinationSurveyId
 END
 ELSE
 BEGIN
 SET @sql = ''
  UPDATE ''+@destinationSchemaName+''.[Respondent]
  SET
  ResEmail = p.Email,
  ResPhone = p.Phone,
  ResActive = case when p.status=6 then 0 else 1 end,
  ResLanguageCode = p.Language,
  ResTimeZone = p.TimeZone  
  FROM #PanelistToInsert pti
  INNER JOIN ''+@panelSchema+''.[dbo].[Panelists] p WITH(NOLOCK) ON p.[Id] = pti.[Id]
  WHERE PanelistId = p.id''
 
  EXEC sp_executesql @sql
 END

 IF @doPanelistDataTransfer = 1
 BEGIN
    IF @updateOnly = 0
    BEGIN
        -- Clear all panelist basic field answers before inserting them
        SET @sql = ''
        DELETE sourceResponse FROM ''+@destinationSchemaName+''.[Response] sourceResponse
        INNER JOIN ''+@destinationSchemaName+''.[Respondent] sourceRespondent WITH(NOLOCK) ON sourceResponse.[RpsRespondent] = sourceRespondent.[ResRespondent]
        INNER JOIN #PanelistToInsert panelist ON panelist.[Id] = sourceRespondent.[panelistId]
        WHERE [RpsQuestion] IN(''''PANELISTGROUPS'''', ''''FIRSTNAME'''', ''''LASTNAME'''', ''''GENDER'''', ''''DATEOFBIRTH'''', ''''USERNAME'''')
        AND [RpsMatrix] = 1 AND [RpsMention] = 1''

        EXEC sp_executesql @sql
    END 

    SET @sql = ''
    INSERT INTO ''+@destinationSchemaName+''.[Response]
    ([RpsRespondent], [RpsVariableId], [RpsQuestion], [RpsMatrix], [RpsMention], [RpsContent], [projectId], [modifiedBy], [modified], [ImportedValue], [source])
    SELECT respondent.[ResRespondent], v.[Id], v.[Name], 1, 1, pv.[Value], @surveyId, @userId, GETUTCDATE(), pv.[Value], 4
    FROM 
 (
     SELECT pa.[PanelistId], ad.[Name], pa.[Value]
     FROM #PanelistToInsert pti
     INNER JOIN ''+@panelSchema+''.[dbo].[PanelistAttributes] pa WITH(NOLOCK)        ON  pa.[PanelistId] = pti.[Id]
     INNER JOIN ''+@panelSchema+''.[dbo].[AttributeDefinitions] ad WITH(NOLOCK)      ON  ad.[Id] = pa.[AttributeDefinitionId] 
                                                                                   AND ad.PanelId=''+cast(@PanelId as varchar(max))+'' 
                                                                                   AND ad.Name NOT IN (''''FIRSTNAME'''', ''''LASTNAME'''', ''''USERNAME'''', ''''GENDER'''', ''''DATEOFBIRTH'''', ''''PANELISTGROUPS'''')
     UNION ALL
     SELECT p.[Id], n.[Name],
     [Value] = 
     CASE n.[Name]
      WHEN ''''FIRSTNAME'''' THEN p.[FirstName]
      WHEN ''''LASTNAME'''' THEN p.[LastName]
      WHEN ''''USERNAME'''' THEN p.[Username]
      WHEN ''''GENDER'''' THEN CONVERT(nvarchar, p.[Gender])
      WHEN ''''DATEOFBIRTH'''' THEN CONVERT(nvarchar, p.[DateOfBirth], 126)
      WHEN ''''PANELISTGROUPS'''' THEN p.[Groups]
     END
     FROM 
     (
      SELECT [Id], [FirstName], [LastName], [Username], [Gender], [DateOfBirth],
            CASE WHEN [1] IS NULL THEN '''''''' ELSE [1] END +
            CASE WHEN [2] IS NULL THEN '''''''' ELSE '''';'''' + [2] END +
            CASE WHEN [3] IS NULL THEN '''''''' ELSE '''';'''' + [3] END +
            CASE WHEN [4] IS NULL THEN '''''''' ELSE '''';'''' + [4] END +
            CASE WHEN [5] IS NULL THEN '''''''' ELSE '''';'''' + [5] END +
            CASE WHEN [6] IS NULL THEN '''''''' ELSE '''';'''' + [6] END +
            CASE WHEN [7] IS NULL THEN '''''''' ELSE '''';'''' + [7] END +
            CASE WHEN [8] IS NULL THEN '''''''' ELSE '''';'''' + [8] END +
            CASE WHEN [9] IS NULL THEN '''''''' ELSE '''';'''' + [9] END +
            CASE WHEN [10] IS NULL THEN '''''''' ELSE '''';'''' + [10] END
            AS Groups
            FROM (
                SELECT p.[Id], p.[FirstName], p.[LastName], p.[Username], p.[Gender], p.[DateOfBirth], g.[Name],
                ROW_NUMBER() OVER (PARTITION BY p.[Id] ORDER BY p.[Id]) AS RowNum
                FROM #PanelistToInsert pti
    INNER JOIN ''+@panelSchema+''.[dbo].[Panelists] p WITH(NOLOCK) ON pti.[Id] = p.[Id]
                LEFT JOIN ''+@panelSchema+''.[dbo].[PanelistGroup] pg WITH(NOLOCK) ON p.[Id] = pg.[Panelists_Id]
                LEFT JOIN ''+@panelSchema+''.[dbo].[Groups] g WITH(NOLOCK) ON pg.[Groups_Id] = g.[Id]
            ) AS SourceTable
            PIVOT
            (
             MAX([Name])
             FOR RowNum IN ([1], [2], [3], [4], [5], [6], [7], [8], [9], [10])
            ) AS PivotTable
     ) p
     CROSS APPLY
     (
      VALUES
            (''''FIRSTNAME''''),
      (''''LASTNAME''''),
      (''''USERNAME''''),
      (''''GENDER''''),
      (''''DATEOFBIRTH''''),
      (''''PANELISTGROUPS'''')
     ) n ([Name])
    ) pv
    INNER JOIN ''+@schemaName+''.[SAT].[Variables] v WITH(NOLOCK) ON v.[Name] = pv.[Name] AND v.[Version] = 0 
    INNER JOIN ''+@schemaName+''.[SAT].[BlockItems] bi WITH(NOLOCK) On bi.[Id] = v.[QuestionId] AND bi.[Version] = v.[Version]
    INNER JOIN ''+@schemaName+''.[SAT].[Blocks] b WITH(NOLOCK) ON b.[Id] = bi.[BlockId] AND b.[Version] = bi.[Version]
    INNER JOIN ''+@destinationSchemaName+''.[Respondent] respondent WITH(NOLOCK) ON respondent.[panelistId] = pv.[PanelistId]''

    IF @updateOnly=1 
    BEGIN
        SET @sql = @sql +
        '' LEFT JOIN ''+@destinationSchemaName+''.[Response] destinationResponse WITH(NOLOCK)
        ON destinationResponse.[RpsRespondent] = respondent.[ResRespondent] AND destinationResponse.[RpsQuestion] = pv.[Name]
        AND destinationResponse.[RpsMatrix] = 1 AND destinationResponse.[RpsMention] = 1
        WHERE  b.[QuestionnaireId] = @surveyId AND destinationResponse.[RpsRespondent] IS NULL''
    END
    ELSE
    BEGIN
        SET @sql = @sql + '' WHERE  b.[QuestionnaireId] = @surveyId''
    END

    EXEC sp_executesql @sql, N''@surveyId INT, @userId INT'', @destinationSurveyId, @userId
 END 
END
'

declare @PanelClientPayload03 nvarchar(max) = N'
IF EXISTS (SELECT * FROM sys.objects WHERE [object_id] = OBJECT_ID(''[dbo].[A4S_sp_ProcessSampleForPanelist]'') AND type IN (''P''))
   DROP PROCEDURE [dbo].[A4S_sp_ProcessSampleForPanelist]
'

declare @PanelClientPayload04 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_ProcessSampleForPanelist]
 @clientId    INT,
 @panelId    INT,
 @sampleId    INT,
 @userId     INT,
 @destinationSurveyId INT,
 @panelistId INT,
 @doPanelistDataTransfer BIT,
 @autoGeneratePIN  INT,
 @pinSource    nvarchar(max) = '''',
 @updateOnly bit = 0
AS
BEGIN
 DECLARE @schemaName NVARCHAR(50)
 DECLARE @destinationSchemaName NVARCHAR(100)
 DECLARE @panelSchema NVARCHAR(50)
 DECLARE @sql NVARCHAR(max)
 SET @schemaName = ''[A4Survey_Client_''+CONVERT(nvarchar, @clientId)+'']''
 SET @destinationSchemaName = @schemaName+''.[Survey_''+CONVERT(nvarchar, @clientId)+''_''+CONVERT(nvarchar, @destinationSurveyId)+'']''
 SET @panelSchema = ''[A4Panel_Client_''+CONVERT(nvarchar, @clientId)+'']''

 IF @updateOnly = 0
 BEGIN
    DECLARE @attributeId int = 0
    DECLARE @panelistProperty int = 0  

    -- When not auto generate then check if source exists and what is the source
    IF @autoGeneratePIN = 0
    BEGIN  
        SET @attributeId = dbo.GetPanelAttributeId(@panelid, @pinSource)

        -- If not a panelist attribute check if panelists property
        IF @attributeId = 0
        BEGIN
            SET @panelistProperty = dbo.IsPanelistProperty(@pinSource)
        END
    END
    
    -- If no panelist property for PIN generation then make sure we have a valid column name for the SQL query
    IF @panelistProperty = 0
    BEGIN
        SET @pinSource = ''UserName''
    END

  SET @sql = ''
  INSERT INTO ''+@destinationSchemaName+''.[Respondent] 
  ([panelistId], [ResEmail], [ResPhone], [CreatedBy],[CreationDate], [modifiedby],[modified],[ResCompleted], [ResActive], [ResAcquiredLicense], [SampleId], [ResPin], [ResLanguageCode], [ResTimeZone])
  SELECT panelist.[Id], panelist.[Email], panelist.[Phone], @userId, GETUTCDATE(), @userId, 0 ,0, case when panelist.status=6 then 0 else 1 end, 0, @sampleId,
  CASE WHEN  @autoGeneratePIN  = 0 AND @panelistProperty = 1 THEN panelist.['' + @pinSource + '']
    WHEN @autoGeneratePIN  = 0 AND @attributeId > 0 THEN attribute.Value
    ELSE CONVERT(nvarchar, @panelId)+LEFT(NEWID(),5)+CONVERT(nvarchar, panelist.[Id]) 
  END, 
  panelist.[Language], panelist.[TimeZone]
  FROM ''+@panelSchema+''.[dbo].[Panelists] panelist WITH(NOLOCK)
  LEFT OUTER JOIN ''+@panelSchema+''.[dbo].[PanelistAttributes] attribute WITH(NOLOCK) ON attribute.PanelistId = panelist.[Id] AND attribute.AttributeDefinitionId = @attributeId
  WHERE panelist.[Id] = @panelistId AND NOT EXISTS (SELECT 1 FROM ''+@destinationSchemaName+''.[Respondent] r WITH(NOLOCK) WHERE r.[panelistId] = panelist.Id)''
 
  EXEC sp_executesql @sql, N''@surveyId INT, @sampleId INT, @panelId INT, @panelistId INT, @userId INT, @autoGeneratePIN INT, @panelistProperty INT, @attributeId int '', @destinationSurveyId, @sampleId, @panelId, @panelistId, @userId,  @autoGeneratePIN, @panelistProperty, @attributeId

  -- Insert created respondents in PanelistRespondents table
  SET @sql = ''
  INSERT INTO ''+@panelSchema+''.[dbo].[PanelistRespondents] ([SurveyId], [PanelistId], [RespondentId], [RespondentActive], [RespondentOnline]) 
  SELECT @surveyId, res.[PanelistId], res.[ResRespondent], res.[ResActive], res.[ResOnline]
  FROM ''+@destinationSchemaName+''.[Respondent] res WITH(NOLOCK) 
  WHERE res.[PanelistId] = @panelistId''

  EXEC sp_executesql @sql, N''@surveyId INT, @panelistId INT'', @destinationSurveyId, @panelistId
 END
 ELSE
 BEGIN
 SET @sql = ''
  UPDATE ''+@destinationSchemaName+''.[Respondent]
  SET
  ResEmail = p.Email,
  ResPhone = p.Phone,
  ResActive = case when p.status=6 then 0 else 1 end,
  ResLanguageCode = p.Language,
  ResTimeZone = p.TimeZone  
  FROM ''+@panelSchema+''.[dbo].[Panelists] p
  WHERE p.[Id] = @panelistId AND PanelistId = p.id''
 
  EXEC sp_executesql @sql, N''@panelistId INT'', @panelistId
 END

 IF @doPanelistDataTransfer = 1
 BEGIN
    IF @updateOnly = 0
    BEGIN
        -- Clear all panelist basic field answers before inserting them
        SET @sql = ''
        DELETE sourceResponse FROM ''+@destinationSchemaName+''.[Response] sourceResponse
        INNER JOIN ''+@destinationSchemaName+''.[Respondent] sourceRespondent WITH(NOLOCK) ON sourceResponse.[RpsRespondent] = sourceRespondent.[ResRespondent]
        WHERE sourceRespondent.[panelistId] = @panelistId
        AND [RpsQuestion] IN(''''PANELISTGROUPS'''', ''''FIRSTNAME'''', ''''LASTNAME'''', ''''GENDER'''', ''''DATEOFBIRTH'''', ''''USERNAME'''')
        AND [RpsMatrix] = 1 AND [RpsMention] = 1''

        EXEC sp_executesql @sql, N''@panelistId INT'', @panelistId
    END 

    SET @sql = ''
    INSERT INTO ''+@destinationSchemaName+''.[Response]
    ([RpsRespondent], [RpsVariableId], [RpsQuestion], [RpsMatrix], [RpsMention], [RpsContent], [projectId], [modifiedBy], [modified], [ImportedValue], [source])
    SELECT respondent.[ResRespondent], v.[Id], v.[Name], 1, 1, pv.[Value], @surveyId, @userId, GETUTCDATE(), pv.[Value], 4
    FROM 
	(
	    SELECT pa.[PanelistId], ad.[Name], pa.[Value]
		FROM ''+@panelSchema+''.[dbo].[PanelistAttributes] pa WITH(NOLOCK)
        INNER JOIN ''+@panelSchema+''.[dbo].[AttributeDefinitions] ad WITH(NOLOCK)   ON  ad.[Id] = pa.[AttributeDefinitionId] 
                                                                                   AND ad.PanelId=''+cast(@PanelId as varchar(max))+'' 
                                                                                   AND ad.Name NOT IN (''''FIRSTNAME'''', ''''LASTNAME'''', ''''USERNAME'''', ''''GENDER'''', ''''DATEOFBIRTH'''', ''''PANELISTGROUPS'''')
        WHERE pa.[PanelistId] = @panelistId
	    UNION ALL
	    SELECT p.[Id], n.[Name],
	    [Value] = 
	    CASE n.[Name]
		    WHEN ''''FIRSTNAME'''' THEN p.[FirstName]
		    WHEN ''''LASTNAME'''' THEN p.[LastName]
		    WHEN ''''USERNAME'''' THEN p.[Username]
		    WHEN ''''GENDER'''' THEN CONVERT(nvarchar, p.[Gender])
		    WHEN ''''DATEOFBIRTH'''' THEN CONVERT(nvarchar, p.[DateOfBirth], 126)
		    WHEN ''''PANELISTGROUPS'''' THEN p.[Groups]
	    END
	    FROM 
	    (
		    SELECT [Id], [FirstName], [LastName], [Username], [Gender], [DateOfBirth],
            CASE WHEN [1] IS NULL THEN '''''''' ELSE [1] END +
            CASE WHEN [2] IS NULL THEN '''''''' ELSE '''';'''' + [2] END +
            CASE WHEN [3] IS NULL THEN '''''''' ELSE '''';'''' + [3] END +
            CASE WHEN [4] IS NULL THEN '''''''' ELSE '''';'''' + [4] END +
            CASE WHEN [5] IS NULL THEN '''''''' ELSE '''';'''' + [5] END +
            CASE WHEN [6] IS NULL THEN '''''''' ELSE '''';'''' + [6] END +
            CASE WHEN [7] IS NULL THEN '''''''' ELSE '''';'''' + [7] END +
            CASE WHEN [8] IS NULL THEN '''''''' ELSE '''';'''' + [8] END +
            CASE WHEN [9] IS NULL THEN '''''''' ELSE '''';'''' + [9] END +
            CASE WHEN [10] IS NULL THEN '''''''' ELSE '''';'''' + [10] END
            AS Groups
            FROM (
                SELECT p.[Id], p.[FirstName], p.[LastName], p.[Username], p.[Gender], p.[DateOfBirth], g.[Name],
                ROW_NUMBER() OVER (PARTITION BY p.[Id] ORDER BY p.[Id]) AS RowNum
                FROM ''+@panelSchema+''.[dbo].[Panelists] p WITH(NOLOCK)
                LEFT JOIN ''+@panelSchema+''.[dbo].[PanelistGroup] pg WITH(NOLOCK) ON p.[Id] = pg.[Panelists_Id]
                LEFT JOIN ''+@panelSchema+''.[dbo].[Groups] g WITH(NOLOCK) ON pg.[Groups_Id] = g.[Id]
                WHERE p.[Id] = @panelistId
            ) AS SourceTable
            PIVOT
            (
	            MAX([Name])
	            FOR RowNum IN ([1], [2], [3], [4], [5], [6], [7], [8], [9], [10])
            ) AS PivotTable
	    ) p
	    CROSS APPLY
	    (
		    VALUES
            (''''FIRSTNAME''''),
		    (''''LASTNAME''''),
		    (''''USERNAME''''),
		    (''''GENDER''''),
		    (''''DATEOFBIRTH''''),
		    (''''PANELISTGROUPS'''')
	    ) n ([Name])
    ) pv
    INNER JOIN ''+@schemaName+''.[SAT].[Variables] v WITH(NOLOCK) ON v.[Name] = pv.[Name] AND v.[Version] = 0 
    INNER JOIN ''+@schemaName+''.[SAT].[BlockItems] bi WITH(NOLOCK) On bi.[Id] = v.[QuestionId] AND bi.[Version] = v.[Version]
    INNER JOIN ''+@schemaName+''.[SAT].[Blocks] b WITH(NOLOCK) ON b.[Id] = bi.[BlockId] AND b.[Version] = bi.[Version]
    INNER JOIN ''+@destinationSchemaName+''.[Respondent] respondent WITH(NOLOCK) ON respondent.[panelistId] = pv.[PanelistId]''

    IF @updateOnly=1 
    BEGIN
        SET @sql = @sql +
        '' LEFT JOIN ''+@destinationSchemaName+''.[Response] destinationResponse WITH(NOLOCK)
        ON destinationResponse.[RpsRespondent] = respondent.[ResRespondent] AND destinationResponse.[RpsQuestion] = pv.[Name]
        AND destinationResponse.[RpsMatrix] = 1 AND destinationResponse.[RpsMention] = 1
        WHERE  b.[QuestionnaireId] = @surveyId AND destinationResponse.[RpsRespondent] IS NULL''
    END
    ELSE
    BEGIN
        SET @sql = @sql + '' WHERE  b.[QuestionnaireId] = @surveyId''
    END

    EXEC sp_executesql @sql, N''@surveyId INT, @panelistId INT, @userId INT'', @destinationSurveyId, @panelistId, @userId
 END 
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)

declare @AllDone bit = 0, 
        @TotalPanelClients int, 
		@PanelClientCounter int, 
		@ThisPanelClient nvarchar(128), 
		@PanelClientCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalPanelClients = 0, @PanelClientCounter = 0
	insert into #DB 
	select 'A4Panel_Client_' + cast(Id as nvarchar(16)), 0 
	       from Acuity4.dbo.Client
	       where DB_ID( 'A4Panel_Client_' + cast(Id as nvarchar(16)) ) IS NOT NULL

    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Panel_Client_Template', 0)

	select @TotalPanelClients = count(*) 
	       from #DB

	set @PanelClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @PanelClientCursor
	fetch next from @PanelClientCursor into @ThisPanelClient
	while @@FETCH_STATUS = 0 begin
		select @PanelClientCounter += 1
		select @DBSQL = @ThisPanelClient + N'.sys.sp_executesql'
		select @StatusMessage = 'Updating panel client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @PanelClientCounter / @TotalPanelClients
		raiserror (@StatusMessage, 0, 1, @ThisPanelClient, @PanelClientCounter, @TotalPanelClients, @StatusPercent) with nowait
		
		print 'Panel Client Payload 1'
		select @SQL = replace(replace(@PanelClientPayload01, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 2'
		select @SQL = replace(replace(@PanelClientPayload02, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 3'
		select @SQL = replace(replace(@PanelClientPayload03, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Panel Client Payload 4'
		select @SQL = replace(replace(@PanelClientPayload04, '#CLIENT ID#', substring(@ThisPanelClient, 16, 8)), '#CLIENT DB#', @ThisPanelClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Panel Client Payload done for panel client ' + @ThisPanelClient + '!'

		update #DB set Processed = 1 where current of @PanelClientCursor
		fetch next from @PanelClientCursor into @ThisPanelClient
	end


	close @PanelClientCursor
	deallocate @PanelClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Panel_Client_Template';
      SET @SQL = 'USE A4Panel;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
